var simudev = {};

(function() {
'use strict';

simudev.getPorts = function() {
    return navigator.usb.getDevices().then(devices => {
    return devices.map(device => new simudev.Port(device));
    });
};

simudev.requestPort = function() {
    const filters = [
    { 'vendorId': 0x0403, 'productId': 0x6014 },  // FT232H
    { 'vendorId': 0x0403, 'productId': 0x6010 },  // FT2232H
    { 'vendorId': 0x0403, 'productId': 0x6042 },  // FT2232H for ALogic
    { 'vendorId': 0x0403, 'productId': 0x6011 },  // FT4232H
    ];
    return navigator.usb.requestDevice({ 'filters': filters }).then(
    device => new simudev.Port(device)
    );
}

simudev.Port = function(device) {
    this.device_ = device;
    this.interfaceNumber_ = 0;
    this.endpointIn_ = 1;
    this.endpointOut_ = 2;
};

simudev.Port.prototype.connect = function() {
    console.log("Connect...");

    let readLoop = () => {
    this.device_.transferIn(this.endpointIn_, 512).then(result => {
        if (this.device_.opened) {
        this.onReceive(result.data);
        readLoop();
        }
    }, error => {
        this.onReceiveError(error);
    });
    };

    return this.device_.open()
        .then(() => {
        if (this.device_.configuration === null) {
            console.log("selectConfiguration(1)");
            return this.device_.selectConfiguration(1);
        }
        })
        .then(() => {
        })
        .then(() => this.device_.claimInterface(this.interfaceNumber_))
        .then(() => this.device_.selectAlternateInterface(this.interfaceNumber_, 0))
        .then(() => {
        readLoop();
        });
};

simudev.Port.prototype.disconnect = function() {
    console.log("Disconnect...");
    this.device_.close()
};

simudev.Port.prototype.send = function(data) {
    return this.device_.transferOut(this.endpointOut_, data);
};
})();